<?php

/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package NewsCard
 */

get_header();

newscard_layout_primary(); ?>
<main id="main" class="site-main h-auto">
	<div class="row">
		<div class="col-12 custom-breadcrumbs">
			<?php

			custom_breadcrumbs();
			?>
		</div>
	</div>
	<div class="row align-items-start">
		<div class="col single-content-row">

			<?php if (!is_front_page() && !is_home() && !is_page_template('templates/front-page-template.php') && function_exists('newscard_breadcrumbs') && $newscard_settings['newscard_breadcrumbs_hide'] === 0) { ?>
				<div id="breadcrumb">
					<div class="container">
						<?php newscard_breadcrumbs(); ?>
					</div>
				</div><!-- .breadcrumb -->
			<?php } ?>

			<?php
			while (have_posts()) :
				the_post();

				get_template_part('template-parts/content', get_post_type());

				// the_post_navigation();

				// If comments are open or we have at least one comment, load up the comment template.
				if (comments_open() || get_comments_number()) :
					comments_template();
				endif;

			endwhile; // End of the loop.
			?>
		</div>
		<div class="col-5 max-w-467 px-2">
			<?php if (((!is_front_page() || (!is_home() && $newscard_settings['newscard_banner_display'] === 'front-blog')) && ($newscard_settings['newscard_banner_slider_posts_hide'] === 0 || $newscard_settings['newscard_banner_featured_posts_1_hide'] === 0 || $newscard_settings['newscard_banner_featured_posts_2_hide'] === 0)) || ((is_front_page() || (is_home() && $newscard_settings['newscard_header_featured_posts_banner_display'] === 'front-blog')) && $newscard_settings['newscard_header_featured_posts_hide'] === 0)) { ?>
				<section class="featured-section featured-section--sidebar">
					<?php if ((!is_front_page() || (!is_home() && $newscard_settings['newscard_banner_display'] === 'front-blog')) && ($newscard_settings['newscard_banner_slider_posts_hide'] === 0 || $newscard_settings['newscard_banner_featured_posts_1_hide'] === 0 || $newscard_settings['newscard_banner_featured_posts_2_hide'] === 0)) {

						$col_wrap_class = '';
						$col_slider_class = '';
						$col_mid_class = '';
						$col_mid_child_class = '';

						if ($newscard_settings['newscard_banner_featured_posts_1_hide'] === 0 && $newscard_settings['newscard_banner_featured_posts_2_hide'] === 0) {
							$col_slider_class = 'col-12';
							$col_mid_class = '';
							$col_mid_child_class = 'col-12';
						} elseif (($newscard_settings['newscard_banner_featured_posts_1_hide'] === 1 && $newscard_settings['newscard_banner_featured_posts_2_hide'] === 0) || ($newscard_settings['newscard_banner_featured_posts_1_hide'] === 0 && $newscard_settings['newscard_banner_featured_posts_2_hide'] === 1)) {
							$col_slider_class = 'col-12';
							$col_wrap_class = 'two-column-featured-section';
							$col_mid_class = 'col-12';
							$col_mid_child_class = 'col-12';
						} else {
							$col_slider_class = 'col-12';
							$col_wrap_class = 'one-column-featured-section';
						}

					?>
						<div class="container">
							<div class="row  <?php echo $col_wrap_class ?>">
							<?php if ($newscard_settings['newscard_banner_slider_posts_hide'] === 0) {

								$newscard_bs_cat = absint($newscard_settings['newscard_banner_slider_post_categories']);

								$post_type_bs = array(
									'posts_per_page' => 5,
									'post__not_in' => get_option('sticky_posts'),
									'post_type' => array(
										'post'
									),
								);
								if ($newscard_settings['newscard_banner_slider_latest_post'] == 'category') {
									$post_type_bs['category__in'] = $newscard_bs_cat;
								}

								$newscard_get_banner_slider = new WP_Query($post_type_bs); ?>

								<div class="<?php echo $col_slider_class ?>">
									<div class="featured-slider featured-slider--sidebar featured-slider--height post-slider<?php echo ($newscard_settings['newscard_banner_slider_posts_title'] === '') ? " slider-no-title" : ""; ?>">

										<div class="owl-carousel">
											<?php while ($newscard_get_banner_slider->have_posts()) {
												$newscard_get_banner_slider->the_post(); ?>
												<div class="item">
													<div class="post-col post-col--full-height">
														<div <?php post_class(); ?>>

															<?php if (has_post_thumbnail()) { ?>

																<figure class="post-featured-image post-img-wrap">
																	<a title="<?php the_title_attribute(); ?>" href="<?php the_permalink(); ?>" class="post-img" <?php if (has_post_thumbnail()) { ?> style="background-image: url('<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'full')); ?>');" <?php } ?>></a>
																	<?php if ('post' === get_post_type()) { ?>
																		<div class="entry-meta category-meta">
																			<div class="cat-links">
																				<?php
																					$terms = get_the_terms(get_the_ID(), 'category');
																					foreach($terms as $term) :
																						if ($term->slug != 'sexy') :
																				?>
																					<a href="<?php echo get_term_link($term->term_id); ?>"><?php echo $term->name; ?></a>
																				<?php endif; endforeach; ?>		
																			</div>
																		</div><!-- .entry-meta -->
																	<?php } ?>
																</figure><!-- .post-featured-image .post-img-wrap -->

															<?php } elseif ('post' === get_post_type()) { ?>

																<div class="entry-meta category-meta">
																	<div class="cat-links">
																		<?php
																			$terms = get_the_terms(get_the_ID(), 'category');
																			foreach($terms as $term) :
																				if ($term->slug != 'sexy') :
																		?>
																			<a href="<?php echo get_term_link($term->term_id); ?>"><?php echo $term->name; ?></a>
																		<?php endif; endforeach; ?>		
																	</div>
																</div><!-- .entry-meta -->

															<?php } ?>

															<?php if (!has_post_format('quote')) { // for not format quote 
															?>

																<header class="entry-header">

																	<?php the_title('<h2 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>'); ?>
																	<div class="entry-content">

																		<?php if (!(has_post_format('link') || has_post_format('quote'))) { ?>

																			<p><?php echo wp_trim_words(get_the_excerpt(), 16); ?></p>

																		<?php } else {

																			the_content();
																		} ?>

																	</div>
																	<!-- .entry-content -->
																	<?php if ('post' === get_post_type() && !has_post_format('link')) { ?>

																		<div class="entry-meta">
																			<?php newscard_posted_on(); ?>
																			<?php if (comments_open() && get_comments_number()) { ?>
																				<div class="comments">
																					<?php comments_popup_link(__('No Comments', 'newscard'), __('1 Comment', 'newscard'), __('% Comments', 'newscard'), '', __('Comments Off', 'newscard')); ?>
																				</div><!-- .comments -->
																			<?php } ?>
																		</div><!-- .entry-meta -->

																	<?php } ?>
																</header><!-- .entry-header -->

															<?php } ?>

														</div><!-- .post-<?php the_ID(); ?> -->
													</div><!-- .col-sm-6 .col-xxl-4 .post-col -->
												</div>
											<?php }
											// Reset Post Data
											wp_reset_postdata(); ?>
										</div><!-- .owl-carousel -->
									</div><!-- .featured-slider .post-slider -->
									<?php if ((is_front_page() || is_home()) && $newscard_settings['newscard_top_stories_hide'] === 0) {

										$newscard_cat_tp = absint($newscard_settings['newscard_top_stories_categories']);

										$post_type_tp = array(
											'posts_per_page' => 5,
											'post__not_in' => get_option('sticky_posts'),
											'post_type' => array(
												'post'
											),
										);
										if ($newscard_settings['newscard_top_stories_latest_post'] == 'category') {
											$post_type_tp['category__in'] = $newscard_cat_tp;
										}

										$newscard_get_top_stories = new WP_Query($post_type_tp); ?>

									<?php } ?>
								</div><!-- <?php echo $col_slider_class ?> -->
								<div class="mw-451">
									<!-- <div class="container d-flex mb-30 max-w-467 titles p-0">

									<div class="title-wrap">
										<?php newscard_sections_title($newscard_settings['newscard_banner_slider_latest_post'], $newscard_settings['newscard_banner_slider_posts_title'], $newscard_bs_cat); ?>
									</div>
									<div class="title-wrap">
										<?php newscard_sections_title($newscard_settings['newscard_banner_featured_posts_2_latest_post'], $newscard_settings['newscard_banner_featured_posts_2_title'], $newscard_fp_2_cat); ?>
									</div>
									<div class="title-wrap">
										<?php newscard_sections_title($newscard_settings['newscard_banner_featured_posts_1_latest_post'], $newscard_settings['newscard_banner_featured_posts_1_title'], $newscard_fp_1_cat); ?>
									</div>
								</div>
								<a class="link-to-actual" href="/category/actu/">voir toutes les actualités <svg xmlns="http://www.w3.org/2000/svg" width="18" height="19" viewBox="0 0 18 19" fill="none">
										<path d="M4.5 14.75L14.25 5M14.25 5V14.36M14.25 5H4.89" stroke="black" stroke-width="1.28571" stroke-linecap="round" stroke-linejoin="round" />
									</svg></a> -->
								</div>

							<?php } ?>

							<?php if ($newscard_settings['newscard_banner_featured_posts_1_hide'] === 0) {

								$newscard_fp_1_cat = absint($newscard_settings['newscard_banner_featured_posts_1_post_categories']);

								$post_type_fp_1 = array(
									'posts_per_page' => 8,
									'post__not_in' => get_option('sticky_posts'),
									'post_type' => array(
										'post'
									),
								);
								if ($newscard_settings['newscard_banner_featured_posts_1_latest_post'] == 'category') {
									$post_type_fp_1['category__in'] = $newscard_fp_1_cat;
								}

								$newscard_get_featured_post_1 = new WP_Query($post_type_fp_1); ?>

								<div class="<?php echo $col_mid_class ?> mw-451">
									<div class="container d-block d-lg-flex mb-30 max-w-467 titles p-0 mobile-w-100">

										<div class="title-wrap">
											<?php newscard_sections_title($newscard_settings['newscard_banner_slider_latest_post'], $newscard_settings['newscard_banner_slider_posts_title'], $newscard_bs_cat); ?>
										</div>
										<div class="title-wrap">
											<?php newscard_sections_title($newscard_settings['newscard_banner_featured_posts_2_latest_post'], $newscard_settings['newscard_banner_featured_posts_2_title'], $newscard_fp_2_cat); ?>
										</div>
										<div class="title-wrap">
											<?php newscard_sections_title($newscard_settings['newscard_banner_featured_posts_1_latest_post'], $newscard_settings['newscard_banner_featured_posts_1_title'], $newscard_fp_1_cat); ?>
										</div>
									</div>
									<a class="link-to-actual" href="/category/actu/">voir toutes les actualités <svg xmlns="http://www.w3.org/2000/svg" width="18" height="19" viewBox="0 0 18 19" fill="none">
											<path d="M4.5 14.75L14.25 5M14.25 5V14.36M14.25 5H4.89" stroke="black" stroke-width="1.28571" stroke-linecap="round" stroke-linejoin="round" />
										</svg></a>
									<div class="featured-post pad-5 featured-post--spec d-flex flex-column gutter-10">
										<div class="row1">
											<?php while ($newscard_get_featured_post_1->have_posts()) {
												$newscard_get_featured_post_1->the_post(); ?>
												<div class="post-col">
													<div <?php post_class(); ?>>

														<?php if (has_post_thumbnail()) { ?>

															<figure class="post-featured-image post-img-wrap">
																<a title="<?php the_title_attribute(); ?>" href="<?php the_permalink(); ?>" class="post-img" <?php if (has_post_thumbnail()) { ?> style="background-image: url('<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'full')); ?>');" <?php } ?>></a>
																<?php if ('post' === get_post_type()) { ?>
																	<div class="entry-meta category-meta">
																		<div class="cat-links">
																			<?php
																				$terms = get_the_terms(get_the_ID(), 'category');
																				foreach($terms as $term) :
																					if ($term->slug != 'sexy') :
																			?>
																				<a href="<?php echo get_term_link($term->term_id); ?>"><?php echo $term->name; ?></a>
																			<?php endif; endforeach; ?>		
																		</div>
																	</div><!-- .entry-meta -->
																<?php } ?>
															</figure><!-- .post-featured-image .post-img-wrap -->

														<?php } elseif ('post' === get_post_type()) { ?>

															<div class="entry-meta category-meta">
																<div class="cat-links">
																	<?php
																		$terms = get_the_terms(get_the_ID(), 'category');
																		foreach($terms as $term) :
																			if ($term->slug != 'sexy') :
																	?>
																		<a href="<?php echo get_term_link($term->term_id); ?>"><?php echo $term->name; ?></a>
																	<?php endif; endforeach; ?>		
																</div>
															</div><!-- .entry-meta -->

														<?php } ?>

														<?php if (!has_post_format('quote')) { // for not format quote 
														?>

															<header class="entry-header">

																<?php the_title('<h2 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>'); ?>

																<?php if ('post' === get_post_type() && !has_post_format('link')) { ?>

																	<div class="entry-meta">
																		<?php newscard_posted_on(); ?>
																		<?php if (comments_open() && get_comments_number()) { ?>
																			<div class="comments">
																				<?php comments_popup_link(__('No Comments', 'newscard'), __('1 Comment', 'newscard'), __('% Comments', 'newscard'), '', __('Comments Off', 'newscard')); ?>
																			</div><!-- .comments -->
																		<?php } ?>
																	</div><!-- .entry-meta -->

																<?php } ?>
															</header><!-- .entry-header -->

														<?php } ?>
														<!-- 
															<div class="entry-content">

																<?php if (!(has_post_format('link') || has_post_format('quote'))) { ?>

																	<p><?php echo wp_trim_words(get_the_excerpt(), 16); ?></p>

																<?php } else {

																	the_content();
																} ?>

															</div> -->
														<!-- .entry-content -->
													</div><!-- .post-<?php the_ID(); ?> -->
												</div><!-- .col-sm-6 .col-xxl-4 .post-col -->
											<?php }
											// Reset Post Data
											wp_reset_postdata(); ?>
										</div><!-- .row -->
									</div><!-- .featured-post -->
								</div><!-- <?php echo $col_mid_class ?> -->
							<?php } ?>
							<!-- <?php the_posts_pagination(
										array(
											'prev_text' => __('Previous', 'newscard'),
											'next_text' => __('Next', 'newscard'),
										)
									); ?> -->
						</div><!-- .row -->
						</div>
					<?php } ?>

					<?php if ((is_front_page() || (is_home() && $newscard_settings['newscard_header_featured_posts_banner_display'] === 'front-blog')) && $newscard_settings['newscard_header_featured_posts_hide'] === 0) {

						$header_newscard_cat = absint($newscard_settings['newscard_header_featured_post_categories']);

						$header_post_type = array(
							'posts_per_page' => 4,
							'post__not_in' => get_option('sticky_posts'),
							'post_type' => array(
								'post'
							),
						);
						if ($newscard_settings['newscard_header_featured_latest_post'] == 'category') {
							$header_post_type['category__in'] = $header_newscard_cat;
						}

						$header_newscard_get_featured_post = new WP_Query($header_post_type); ?>

					<?php } ?>
				</section><!-- .featured-section -->
			<?php } ?>

		</div>
	</div>

</main><!-- #main -->
</div><!-- #primary -->
<!-- <script>
	document.loaded = function() {
		jQuery('.featured-slider--sidebar .owl-carousel').owlCarousel({
			loop: true,
			margin: 0,
			autoplay: true,	
			navText: ['', ''],
			dots: false,
			nav: true,
			smartSpeed: 800,
			autoplayTimeout: 5000,
			responsive: {
				0: {
					items: 1
				},
			}
		});
	}
</script> -->
<?php
do_action('newscard_sidebar');
get_footer();
