<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package NewsCard
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<!-- Google tag (gtag.js) -->
	<script async src="https://www.googletagmanager.com/gtag/js?id=AW-11042897095"></script>
	<script>
		window.dataLayer = window.dataLayer || [];

		function gtag() {
			dataLayer.push(arguments);
		}
		gtag('js', new Date());

		gtag('config', 'AW-11042897095');
	</script>
	<link href="https://fonts.cdnfonts.com/css/inter" rel="stylesheet">
	<link href="https://fonts.cdnfonts.com/css/zen-antique-soft" rel="stylesheet">
	<meta name="facebook-domain-verification" content="pcb5vi9uddlgdkfcxs0wr031r8nni7" />
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<meta name="google-site-verification" content="F3jmVVXzWIdXFsIrwfspytl7Q9jCHBC5ueNvAZvJzjI" />
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>


	<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-9450370143024824" crossorigin="anonymous"></script>
	<!-- Google Tag Manager -->
	<script>
		(function(w, d, s, l, i) {
			w[l] = w[l] || [];
			w[l].push({
				'gtm.start': new Date().getTime(),
				event: 'gtm.js'
			});
			var f = d.getElementsByTagName(s)[0],
				j = d.createElement(s),
				dl = l != 'dataLayer' ? '&l=' + l : '';
			j.async = true;
			j.src =
				'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
			f.parentNode.insertBefore(j, f);
		})(window, document, 'script', 'dataLayer', 'GTM-KVS8267');
	</script>
	<!-- End Google Tag Manager -->

	<!-- Event snippet for Page View conversion page -->
	<script>
		gtag('event', 'conversion', {
			'send_to': 'AW-11042897095/5i1fCPLr-KoYEMf51JEp'
		});
	</script>

</head>

<body <?php body_class('theme-body'); ?>>
	<?php wp_body_open();
	global $newscard_settings;
	$newscard_settings = newscard_get_option_defaults(); ?>
	<!-- Google Tag Manager (noscript) -->
	<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-KVS8267" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
	<!-- End Google Tag Manager (noscript) -->

	<div id="page" class="site">
		<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e('Skip to content', 'newscard'); ?></a>
		<?php if (has_header_video() || has_header_image()) {
			the_custom_header_markup();
		} ?>

		<header id="masthead" class="site-header">
			<!-- <?php if ($newscard_settings['newscard_top_bar_hide'] == 0) { ?>
				<div class="info-bar<?php echo (has_nav_menu('right-section')) ? ' infobar-links-on' : ''; ?>">
					<div class="container">
						<div class="row gutter-10">
							<div class="col col-sm contact-section">
								<div class="date">
									<ul>
										<li><?php echo esc_html(date_i18n("l, F j, Y")); ?></li>
									</ul>
								</div>
							</div>

							<?php if ($newscard_settings['newscard_social_profiles'] != '' && $newscard_settings['newscard_top_bar_social_profiles'] === 0) { ?>
								<div class="col-auto social-profiles order-md-3">
									<?php echo esc_html(newscard_social_profiles()); ?>
								</div>
							<?php }

							if (has_nav_menu('right-section')) { ?>
								<div class="col-md-auto infobar-links order-md-2">
									<button class="infobar-links-menu-toggle"><?php esc_html_e('Responsive Menu', 'newscard'); ?></button>
									<?php wp_nav_menu(array(
										'theme_location'	=> 'right-section',
										'container'			=> '',
										'depth'				=> 1,
										'items_wrap'      	=> '<ul class="clearfix">%3$s</ul>',
									)); ?>
								</div>
							<?php } ?>
						</div>
					</div>
				</div>
			<?php } ?> -->
			<nav class="navbar navbar-expand-lg d-block">
				<div class="navbar-head<?php echo ($newscard_settings['newscard_header_background'] !== '') ? ' navbar-bg-set' : '';
										echo ($newscard_settings['newscard_header_bg_overlay'] === 'dark') ? ' header-overlay-dark' : '';
										echo ($newscard_settings['newscard_header_bg_overlay'] === 'light') ? ' header-overlay-light' : ''; ?>" <?php if ($newscard_settings['newscard_header_background'] !== '') { ?> style="background-image:url('<?php echo esc_url($newscard_settings['newscard_header_background']); ?>');" <?php } ?>>
					<div class="container navbar-head__content">
						<div class="d-none d-lg-block date">
							<ul>
								<li><?php echo esc_html(date_i18n("l, F j, Y")); ?></li>
							</ul>
						</div>
						<div class="row navbar-head-row align-items-center">
							<div class="d-none col-lg-4 d-lg-flex">
								<div class="site-branding navbar-brand ml-md-auto ">
									<?php
									the_custom_logo();
									if (is_page_template('templates/front-page-template.php') || is_home()) :
									?>
										<h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
									<?php
									else :
									?>
										<h2 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a></h2>
									<?php
									endif;
									$newscard_description = get_bloginfo('description', 'display');
									if ($newscard_description || is_customize_preview()) :
									?>
										<p class="site-description"><?php echo $newscard_description; /* WPCS: xss ok. */ ?></p>
									<?php endif; ?>
								</div><!-- .site-branding .navbar-brand -->
							</div>
							<?php if ($newscard_settings['newscard_header_add_image'] !== '') { ?>
								<div class="col-lg-8 navbar-ad-section">
									<?php if ($newscard_settings['newscard_header_add_link'] !== '') { ?>
										<a href="<?php echo esc_url($newscard_settings['newscard_header_add_link']); ?>" class="newscard-ad-728-90" target="_blank" rel="noopener noreferrer">
										<?php } ?>
										<img class="img-fluid" src="<?php echo esc_url($newscard_settings['newscard_header_add_image']); ?>" alt="<?php esc_attr_e('Banner Add', 'newscard'); ?>">
										<?php if ($newscard_settings['newscard_header_add_link'] !== '') { ?>
										</a>
									<?php } ?>
								</div>
							<?php } ?>
						</div><!-- .row -->
						<div class="navigation-bar-top desktop">
							<div class="d-flex align-content-center navigation-bar-top__inner on">
								<button class="navbar-toggler menu-toggle" type="button" data-toggle="collapse" data-target="#navbarCollapse" aria-controls="navbarCollapse" aria-expanded="false" aria-label="<?php esc_attr_e('Toggle navigation', 'newscard'); ?>"></button>
								<span class="search-toggle"></span>
							</div><!-- .container -->
							<div class="search-bar">
								<div class="search-block off">
									<?php get_search_form(); ?>
								</div><!-- .search-box -->
							</div><!-- .search-bar -->
						</div><!-- .navigation-bar-top -->
						<!-- <div class="nav-search">
							<span class="search-toggle"></span>
						</div> -->
					</div><!-- .container -->
				</div><!-- .navbar-head -->
				<div class="navigation-bar">
					<div class="navigation-bar-top container mobile">
						<div class="continer navigation-bar-top__inner on mobile-nav-styles">
							<button class="navbar-toggler menu-toggle" type="button" data-toggle="collapse" data-target="#navbarCollapse" aria-controls="navbarCollapse" aria-expanded="false" aria-label="<?php esc_attr_e('Toggle navigation', 'newscard'); ?>"></button>
							<a href="<?php echo home_url('/') ?>" class="mobile-logo">
								<img src="<?php echo home_url('/wp-content/uploads/2023/11/logonew.png'); ?>" alt="Mobile Logo">
							</a>
							<span class="search-toggle"></span>
							<div class="search-bar">
								<div class="search-block off">
									<?php get_search_form(); ?>
								</div><!-- .search-box -->
							</div><!-- .search-bar -->
						</div><!-- .container -->
					</div><!-- .navigation-bar-top -->
					<div class="navbar-main">
						<div class="container">
							<div class="collapse navbar-collapse" id="navbarCollapse">
								<div id="site-navigation" class="main-navigation<?php echo ($newscard_settings['newscard_nav_uppercase'] == 1) ? " nav-uppercase" : ""; ?>" role="navigation">
									<?php
									if (has_nav_menu('primary')) {
										wp_nav_menu(array(
											'theme_location'	=> 'primary',
											'container'			=> '',
											'items_wrap'		=> '<ul class="nav-menu navbar-nav d-lg-block">%3$s</ul>',
										));
									} else {
										wp_page_menu(array(
											'before' 			=> '<ul class="nav-menu navbar-nav d-lg-block">',
											'after'				=> '</ul>',
										));
									}
									?>
								</div><!-- #site-navigation .main-navigation -->
							</div><!-- .navbar-collapse -->
						</div><!-- .container -->
					</div><!-- .navbar-main -->
				</div><!-- .navigation-bar -->
			</nav><!-- .navbar -->

			<?php if (str_contains($_SERVER['REQUEST_URI'], 'contactez-nous')) {
				get_template_part('template-parts/content-about', 'about');
			} elseif (((is_front_page() || (is_home() && $newscard_settings['newscard_banner_display'] === 'front-blog')) && ($newscard_settings['newscard_banner_slider_posts_hide'] === 0 || $newscard_settings['newscard_banner_featured_posts_1_hide'] === 0 || $newscard_settings['newscard_banner_featured_posts_2_hide'] === 0)) || ((is_front_page() || (is_home() && $newscard_settings['newscard_header_featured_posts_banner_display'] === 'front-blog')) && $newscard_settings['newscard_header_featured_posts_hide'] === 0)) { ?>
				<section class="featured-section">
					<div class="container px-lg-0">
						<?php if ((is_front_page() || (is_home() && $newscard_settings['newscard_banner_display'] === 'front-blog')) && ($newscard_settings['newscard_banner_slider_posts_hide'] === 0 || $newscard_settings['newscard_banner_featured_posts_1_hide'] === 0 || $newscard_settings['newscard_banner_featured_posts_2_hide'] === 0)) {

							$col_wrap_class = '';
							$col_slider_class = '';
							$col_mid_class = '';
							$col_mid_child_class = '';

							if ($newscard_settings['newscard_banner_featured_posts_1_hide'] === 0 && $newscard_settings['newscard_banner_featured_posts_2_hide'] === 0) {
								$col_slider_class = 'col-lg-12 col-xl-12';
								$col_mid_class = 'col-sm-12 col-lg-12 pt5 col-xl-12 px-0';
								$col_mid_child_class = 'col-12';
							} elseif (($newscard_settings['newscard_banner_featured_posts_1_hide'] === 1 && $newscard_settings['newscard_banner_featured_posts_2_hide'] === 0) || ($newscard_settings['newscard_banner_featured_posts_1_hide'] === 0 && $newscard_settings['newscard_banner_featured_posts_2_hide'] === 1)) {
								$col_slider_class = 'col-12 col-lg-8';
								$col_wrap_class = 'two-column-featured-section';
								$col_mid_class = 'col-lg-4';
								$col_mid_child_class = 'col-sm-6 col-lg-12';
							} else {
								$col_slider_class = 'col-12';
								$col_wrap_class = 'one-column-featured-section';
							}

						?>
							<div class="row gutter-parent-20 mb-55 <?php echo $col_wrap_class ?>">
								<?php if ($newscard_settings['newscard_banner_slider_posts_hide'] === 0) {

									$newscard_bs_cat = absint($newscard_settings['newscard_banner_slider_post_categories']);

									$post_type_bs = array(
										'posts_per_page' => 5,
										'post__not_in' => get_option('sticky_posts'),
										'post_type' => array(
											'post'
										),
									);
									if ($newscard_settings['newscard_banner_slider_latest_post'] == 'category') {
										$post_type_bs['category__in'] = $newscard_bs_cat;
									}

									$newscard_get_banner_slider = new WP_Query($post_type_bs);
								?>

									<div class="<?php echo $col_slider_class ?>">
										<div class="container slider-container">
											<div class="owl-carousel owl-theme homepage-header-slider">
												<?php
													while ($newscard_get_banner_slider->have_posts()) { $newscard_get_banner_slider->the_post(); 
														$post_id = get_the_ID();
												?>
														<div class="item">
															<div class="hero-slide">
																<img src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>" class="slide-image">
																<div class="slide-info">
																	<div class="category">
																		<?php
																			$terms = get_the_terms($post_id, 'category');
																		?>
																			<a href="<?php echo get_term_link($terms[0]->term_id); ?>" title="<?php echo $terms[0]->name; ?>"><?php echo $terms[0]->name; ?></a>
																	</div>
																	<h2 class="slide-title"><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h2>
																	<div class="slide-meta">
																		<div class="meta-item time"><a href="<?php the_permalink(); ?>" title="<?php the_time('d F, Y'); ?>"><?php the_time('d F, Y'); ?></a></div>
																		<div class="meta-item author">
																			<?php
																				$author_id = get_post_field ('post_author', $post_id);
																				$display_name = get_the_author_meta( 'display_name' , $author_id ); 
																			?>
																			<a href="<?php echo get_author_posts_url(get_the_author_meta( 'ID' )); ?>" title="<?php echo $display_name; ?>"><?php echo $display_name; ?></a>
																		</div>
																	</div>
																	<div class="slide-cat-link">
																		<?php
																			$terms = get_the_terms($post_id, 'category');
																		?>
																			<a href="<?php echo get_term_link($terms[0]->term_id); ?>" title="voir toutes les actualités">
																				voir toutes les actualités
																				<svg xmlns="http://www.w3.org/2000/svg" width="18" height="19" viewBox="0 0 18 19" fill="none">
																					<path d="M4.5 14.75L14.25 5M14.25 5V14.36M14.25 5H4.89" stroke="#FFE328" stroke-width="1.28571" stroke-linecap="round" stroke-linejoin="round"></path>
																				</svg>
																			</a>	
																	</div>
																</div>
															</div>
														</div>
													<?php }
													// Reset Post Data
													wp_reset_postdata(); ?>
											</div>
										</div>
										<!-- End of homepage slider -->
										<?php if ((is_front_page() || is_home()) && $newscard_settings['newscard_top_stories_hide'] === 0) {

											$newscard_cat_tp = absint($newscard_settings['newscard_top_stories_categories']);

											$post_type_tp = array(
												'posts_per_page' => 5,
												'post__not_in' => get_option('sticky_posts'),
												'post_type' => array(
													'post'
												),
											);
											if ($newscard_settings['newscard_top_stories_latest_post'] == 'category') {
												$post_type_tp['category__in'] = $newscard_cat_tp;
											}

											$newscard_get_top_stories = new WP_Query($post_type_tp); ?>

										<?php } ?>
									</div><!-- <?php echo $col_slider_class ?> -->
								<?php } ?>
								<div class="container">
									<?php if ($newscard_settings['newscard_banner_featured_posts_2_hide'] === 0) {

										$newscard_fp_2_cat = absint($newscard_settings['newscard_banner_featured_posts_2_post_categories']);

										$post_type_fp_2 = array(
											'posts_per_page' => 3,
											'post__not_in' => get_option('sticky_posts'),
											'post_type' => array(
												'post'
											),
										);
										if ($newscard_settings['newscard_banner_featured_posts_2_latest_post'] == 'category') {
											$post_type_fp_2['category__in'] = $newscard_fp_2_cat;
										}

										$newscard_get_featured_post_2 = new WP_Query($post_type_fp_2); ?>

										<div class="<?php echo $col_mid_class ?>">

											<div class="featured-post">
												<div class="row by-20">
													<?php while ($newscard_get_featured_post_2->have_posts()) {
														$newscard_get_featured_post_2->the_post(); ?>
														<div class="post-col col-12 col-sm-12 col-md-4">
															<div <?php post_class(); ?>>

																<?php if (has_post_thumbnail()) { ?>

																	<figure class="post-featured-image post-img-wrap">
																		<a title="<?php the_title_attribute(); ?>" href="<?php the_permalink(); ?>" class="post-img" <?php if (has_post_thumbnail()) { ?> style="background-image: url('<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'full')); ?>');" <?php } ?>></a>
																		<?php if ('post' === get_post_type()) { ?>
																			<div class="entry-meta category-meta">
																				<div class="cat-links">
																					<?php
																						$terms = get_the_terms(get_the_ID(), 'category');
																						foreach($terms as $term) :
																							if ($term->slug != 'sexy') :
																					?>
																					<a href="<?php echo get_term_link($term->term_id); ?>"><?php echo $term->name; ?></a>
																					<?php endif; endforeach; ?>
																				</div>
																			</div><!-- .entry-meta -->
																		<?php } ?>
																	</figure><!-- .post-featured-image .post-img-wrap -->

																<?php } elseif ('post' === get_post_type()) { ?>

																	<div class="entry-meta category-meta">
																		<div class="cat-links">
																			<?php
																				$terms = get_the_terms(get_the_ID(), 'category');
																				foreach($terms as $term) :
																					if ($term->slug != 'sexy') :
																			?>
																				<a href="<?php echo get_term_link($term->term_id); ?>"><?php echo $term->name; ?></a>
																			<?php endif; endforeach; ?>	
																		</div>
																	</div><!-- .entry-meta -->

																<?php } ?>

																<?php if (!has_post_format('quote')) { // for not format quote 
																?>

																	<header class="entry-header">

																		<?php the_title('<h2 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>'); ?>

																		<?php if ('post' === get_post_type() && !has_post_format('link')) { ?>

																			<div class="entry-meta">
																				<?php newscard_posted_on(); ?>
																				<?php if (comments_open() && get_comments_number()) { ?>
																					<div class="comments">
																						<?php comments_popup_link(__('No Comments', 'newscard'), __('1 Comment', 'newscard'), __('% Comments', 'newscard'), '', __('Comments Off', 'newscard')); ?>
																					</div><!-- .comments -->
																				<?php } ?>
																			</div><!-- .entry-meta -->

																		<?php } ?>
																	</header><!-- .entry-header -->

																<?php } ?>
																<!-- 
															<div class="entry-content">

																<?php if (!(has_post_format('link') || has_post_format('quote'))) { ?>

																	<p><?php echo wp_trim_words(get_the_excerpt(), 16); ?></p>

																<?php } else {

																	the_content();
																} ?>

															</div> -->
																<!-- .entry-content -->
															</div><!-- .post-<?php the_ID(); ?> -->
														</div><!-- .col-sm-6 .col-xxl-4 .post-col -->
													<?php }
													// Reset Post Data
													wp_reset_postdata(); ?>
												</div><!-- .row -->
											</div><!-- .featured-post -->
										</div><!-- <?php echo $col_mid_class ?> -->
									<?php } ?>

							</div><!-- .row -->
							<?php } ?>


							</div><!-- .container -->
							<div class="top-stories-bar marqueed-content">
								<div class="container">
									<div class="row top-stories-box clearfix">
										<div class="col-sm-auto">
											<div class="top-stories-label">
												<div class="top-stories-label-wrap">
													<span class="flash-icon"></span>
													<span class="label-txt">
														<?php echo esc_html($newscard_settings['newscard_top_stories_title']); ?>
													</span>
												</div>
											</div>
										</div>
										<div class="col-12 col-sm top-stories-lists">
											<div class="row align-items-center">
												<div class="col">
													<div class="marquee<?php echo (is_rtl()) ? " marquee-rtl" : " marquee-ltr"; ?>">
														<?php while ($newscard_get_top_stories->have_posts()) {
															$newscard_get_top_stories->the_post();
															the_title('<a href="' . esc_url(get_permalink()) . '">', '</a>');
														}
														// Reset Post Data
														wp_reset_postdata(); ?>
													</div><!-- .marquee -->
												</div><!-- .col -->
											</div><!-- .row .align-items-center -->
										</div><!-- .col-12 .col-sm .top-stories-lists -->
									</div><!-- .row .top-stories-box -->
								</div><!-- .container -->
							</div><!-- .top-stories-bar -->
				</section><!-- .featured-section -->
			<?php } ?>
			<?php if (((is_front_page() || (is_home() && $newscard_settings['newscard_banner_display'] === 'front-blog')) && ($newscard_settings['newscard_banner_slider_posts_hide'] === 0 || $newscard_settings['newscard_banner_featured_posts_1_hide'] === 0 || $newscard_settings['newscard_banner_featured_posts_2_hide'] === 0)) || ((is_front_page() || (is_home() && $newscard_settings['newscard_header_featured_posts_banner_display'] === 'front-blog')) && $newscard_settings['newscard_header_featured_posts_hide'] === 0)) { ?>
				<section class="featured-section pb-5">
					<div class="container">
						<?php if ((is_front_page() || (is_home() && $newscard_settings['newscard_banner_display'] === 'front-blog')) && ($newscard_settings['newscard_banner_slider_posts_hide'] === 0 || $newscard_settings['newscard_banner_featured_posts_1_hide'] === 0 || $newscard_settings['newscard_banner_featured_posts_2_hide'] === 0)) {

							$col_wrap_class = '';
							$col_slider_class = '';
							$col_mid_class = '';
							$col_mid_child_class = '';

							if ($newscard_settings['newscard_banner_featured_posts_1_hide'] === 0 && $newscard_settings['newscard_banner_featured_posts_2_hide'] === 0) {
								$col_slider_class = 'col-lg-12 col-md-12 col-xl-4';
								$col_mid_class = 'col-sm-12 col-md-12 col-lg-6 pt5 col-xl-4';
								$col_mid_child_class = 'col-12';
							} elseif (($newscard_settings['newscard_banner_featured_posts_1_hide'] === 1 && $newscard_settings['newscard_banner_featured_posts_2_hide'] === 0) || ($newscard_settings['newscard_banner_featured_posts_1_hide'] === 0 && $newscard_settings['newscard_banner_featured_posts_2_hide'] === 1)) {
								$col_slider_class = 'col-12 col-lg-8';
								$col_wrap_class = 'two-column-featured-section';
								$col_mid_class = 'col-lg-4';
								$col_mid_child_class = 'col-sm-6 col-lg-12';
							} else {
								$col_slider_class = 'col-12';
								$col_wrap_class = 'one-column-featured-section';
							}

						?>
							<div class="d-block container d-lg-flex mb-30 titles p-0">

								<div class="title-wrap">
									<?php newscard_sections_title($newscard_settings['newscard_banner_slider_latest_post'], $newscard_settings['newscard_banner_slider_posts_title'], $newscard_bs_cat); ?>
								</div>
								<div class="title-wrap">
									<?php newscard_sections_title($newscard_settings['newscard_banner_featured_posts_2_latest_post'], $newscard_settings['newscard_banner_featured_posts_2_title'], $newscard_fp_2_cat); ?>
								</div>
								<div class="title-wrap">
									<?php newscard_sections_title($newscard_settings['newscard_banner_featured_posts_1_latest_post'], $newscard_settings['newscard_banner_featured_posts_1_title'], $newscard_fp_1_cat); ?>
								</div>
							</div>
							<div class="row gutter-parent-20 by-20 align-items-start <?php echo $col_wrap_class ?>">
								<?php if ($newscard_settings['newscard_banner_slider_posts_hide'] === 0) {

									$newscard_bs_cat = absint($newscard_settings['newscard_banner_slider_post_categories']);

									$post_type_bs = array(
										'posts_per_page' => 5,
										'post__not_in' => get_option('sticky_posts'),
										'post_type' => array(
											'post'
										),
									);
									if ($newscard_settings['newscard_banner_slider_latest_post'] == 'category') {
										$post_type_bs['category__in'] = $newscard_bs_cat;
									}

									$newscard_get_banner_slider = new WP_Query($post_type_bs); ?>

									<div class="<?php echo $col_slider_class ?>">
										<div class="featured-slider featured-slider--height featured-slider--main post-slider<?php echo ($newscard_settings['newscard_banner_slider_posts_title'] === '') ? " slider-no-title" : ""; ?>">

											<div class="owl-carousel">
												<?php while ($newscard_get_banner_slider->have_posts()) {
													$newscard_get_banner_slider->the_post(); ?>
													<div class="item">
														<div class="post-col post-col--full-height">
															<div <?php post_class(); ?>>

																<?php if (has_post_thumbnail()) { ?>

																	<figure class="post-featured-image post-img-wrap">
																		<a title="<?php the_title_attribute(); ?>" href="<?php the_permalink(); ?>" class="post-img" <?php if (has_post_thumbnail()) { ?> style="background-image: url('<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'full')); ?>');" <?php } ?>></a>
																		<?php if ('post' === get_post_type()) { ?>
																			<div class="entry-meta category-meta">
																				<div class="cat-links">
																					<?php
																						$terms = get_the_terms(get_the_ID(), 'category');
																						foreach($terms as $term) :
																							if ($term->slug != 'sexy') :
																					?>
																						<a href="<?php echo get_term_link($term->term_id); ?>"><?php echo $term->name; ?></a>
																					<?php endif; endforeach; ?>	
																				</div>
																			</div><!-- .entry-meta -->
																		<?php } ?>
																	</figure><!-- .post-featured-image .post-img-wrap -->

																<?php } elseif ('post' === get_post_type()) { ?>

																	<div class="entry-meta category-meta">
																		<div class="cat-links">
																			<?php
																				$terms = get_the_terms(get_the_ID(), 'category');
																				foreach($terms as $term) :
																					if ($term->slug != 'sexy') :
																			?>
																				<a href="<?php echo get_term_link($term->term_id); ?>"><?php echo $term->name; ?></a>
																			<?php endif; endforeach; ?>		
																		</div>
																	</div><!-- .entry-meta -->

																<?php } ?>

																<?php if (!has_post_format('quote')) { // for not format quote 
																?>

																	<header class="entry-header">

																		<?php the_title('<h2 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>'); ?>
																		<div class="entry-content">

																			<?php if (!(has_post_format('link') || has_post_format('quote'))) { ?>

																				<p><?php echo wp_trim_words(get_the_excerpt(), 50); ?></p>

																			<?php } else {

																				the_content();
																			} ?>

																		</div>
																		<!-- .entry-content -->
																		<?php if ('post' === get_post_type() && !has_post_format('link')) { ?>

																			<div class="entry-meta">
																				<?php newscard_posted_on(); ?>
																				<?php if (comments_open() && get_comments_number()) { ?>
																					<div class="comments">
																						<?php comments_popup_link(__('No Comments', 'newscard'), __('1 Comment', 'newscard'), __('% Comments', 'newscard'), '', __('Comments Off', 'newscard')); ?>
																					</div><!-- .comments -->
																				<?php } ?>
																			</div><!-- .entry-meta -->

																		<?php } ?>
																	</header><!-- .entry-header -->

																<?php } ?>

															</div><!-- .post-<?php the_ID(); ?> -->
														</div><!-- .col-sm-6 .col-xxl-4 .post-col -->
													</div>
												<?php }
												// Reset Post Data
												wp_reset_postdata(); ?>
											</div><!-- .owl-carousel -->
										</div><!-- .featured-slider .post-slider -->
										<?php if ((is_front_page() || is_home()) && $newscard_settings['newscard_top_stories_hide'] === 0) {

											$newscard_cat_tp = absint($newscard_settings['newscard_top_stories_categories']);

											$post_type_tp = array(
												'posts_per_page' => 5,
												'post__not_in' => get_option('sticky_posts'),
												'post_type' => array(
													'post'
												),
											);
											if ($newscard_settings['newscard_top_stories_latest_post'] == 'category') {
												$post_type_tp['category__in'] = $newscard_cat_tp;
											}

											$newscard_get_top_stories = new WP_Query($post_type_tp); ?>

										<?php } ?>
									</div><!-- <?php echo $col_slider_class ?> -->
								<?php } ?>

								<?php if ($newscard_settings['newscard_banner_featured_posts_1_hide'] === 0) {

									$newscard_fp_1_cat = absint($newscard_settings['newscard_banner_featured_posts_1_post_categories']);

									$post_type_fp_1 = array(
										'posts_per_page' => 2,
										'post__not_in' => get_option('sticky_posts'),
										'post_type' => array(
											'post'
										),
									);
									if ($newscard_settings['newscard_banner_featured_posts_1_latest_post'] == 'category') {
										$post_type_fp_1['category__in'] = $newscard_fp_1_cat;
									}

									$newscard_get_featured_post_1 = new WP_Query($post_type_fp_1); ?>

									<div class="<?php echo $col_mid_class ?>">

										<div class="featured-post  featured-post--spec d-flex flex-column gutter-10">
											<div class="row1">
												<?php while ($newscard_get_featured_post_1->have_posts()) {
													$newscard_get_featured_post_1->the_post(); ?>
													<div class="post-col">
														<div <?php post_class(); ?>>

															<?php if (has_post_thumbnail()) { ?>

																<figure class="post-featured-image post-img-wrap">
																	<a title="<?php the_title_attribute(); ?>" href="<?php the_permalink(); ?>" class="post-img" <?php if (has_post_thumbnail()) { ?> style="background-image: url('<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'full')); ?>');" <?php } ?>></a>
																	<?php if ('post' === get_post_type()) { ?>
																		<div class="entry-meta category-meta">
																			<div class="cat-links">
																				<?php
																					$terms = get_the_terms(get_the_ID(), 'category');
																					foreach($terms as $term) :
																						if ($term->slug != 'sexy') :
																				?>
																					<a href="<?php echo get_term_link($term->term_id); ?>"><?php echo $term->name; ?></a>
																				<?php endif; endforeach; ?>			
																			</div>
																		</div><!-- .entry-meta -->
																	<?php } ?>
																</figure><!-- .post-featured-image .post-img-wrap -->

															<?php } elseif ('post' === get_post_type()) { ?>

																<div class="entry-meta category-meta">
																	<div class="cat-links">
																		<?php
																			$terms = get_the_terms(get_the_ID(), 'category');
																			foreach($terms as $term) :
																				if ($term->slug != 'sexy') :
																		?>
																			<a href="<?php echo get_term_link($term->term_id); ?>"><?php echo $term->name; ?></a>
																		<?php endif; endforeach; ?>
																	</div>
																</div><!-- .entry-meta -->

															<?php } ?>

															<?php if (!has_post_format('quote')) { // for not format quote 
															?>

																<header class="entry-header">

																	<?php the_title('<h2 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>'); ?>

																	<?php if ('post' === get_post_type() && !has_post_format('link')) { ?>

																		<div class="entry-meta">
																			<?php newscard_posted_on(); ?>
																			<?php if (comments_open() && get_comments_number()) { ?>
																				<div class="comments">
																					<?php comments_popup_link(__('No Comments', 'newscard'), __('1 Comment', 'newscard'), __('% Comments', 'newscard'), '', __('Comments Off', 'newscard')); ?>
																				</div><!-- .comments -->
																			<?php } ?>
																		</div><!-- .entry-meta -->

																	<?php } ?>
																</header><!-- .entry-header -->

															<?php } ?>
															<!-- 
															<div class="entry-content">

																<?php if (!(has_post_format('link') || has_post_format('quote'))) { ?>

																	<p><?php echo wp_trim_words(get_the_excerpt(), 16); ?></p>

																<?php } else {

																	the_content();
																} ?>

															</div> -->
															<!-- .entry-content -->
														</div><!-- .post-<?php the_ID(); ?> -->
													</div><!-- .col-sm-6 .col-xxl-4 .post-col -->
												<?php }
												// Reset Post Data
												wp_reset_postdata(); ?>
											</div><!-- .row -->
										</div><!-- .featured-post -->
									</div><!-- <?php echo $col_mid_class ?> -->
								<?php } ?>

								<?php if ($newscard_settings['newscard_banner_featured_posts_2_hide'] === 0) {

									$newscard_fp_2_cat = absint($newscard_settings['newscard_banner_featured_posts_2_post_categories']);

									$post_type_fp_2 = array(
										'posts_per_page' => 2,
										'post__not_in' => get_option('sticky_posts'),
										'post_type' => array(
											'post'
										),
									);
									if ($newscard_settings['newscard_banner_featured_posts_2_latest_post'] == 'category') {
										$post_type_fp_2['category__in'] = $newscard_fp_2_cat;
									}

									$newscard_get_featured_post_2 = new WP_Query($post_type_fp_2); ?>

									<div class="<?php echo $col_mid_class ?>">
										<div class="featured-post featured-post--spec">

											<div class="row1">
												<?php while ($newscard_get_featured_post_2->have_posts()) {
													$newscard_get_featured_post_2->the_post(); ?>


													<div class="post-col">
														<div <?php post_class(); ?>>

															<?php if (has_post_thumbnail()) { ?>

																<figure class="post-featured-image post-img-wrap">
																	<a title="<?php the_title_attribute(); ?>" href="<?php the_permalink(); ?>" class="post-img" <?php if (has_post_thumbnail()) { ?> style="background-image: url('<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'full')); ?>');" <?php } ?>></a>
																	<?php if ('post' === get_post_type()) { ?>
																		<div class="entry-meta category-meta">
																			<div class="cat-links">
																				<?php
																					$terms = get_the_terms(get_the_ID(), 'category');
																					foreach($terms as $term) :
																						if ($term->slug != 'sexy') :
																				?>
																					<a href="<?php echo get_term_link($term->term_id); ?>"><?php echo $term->name; ?></a>
																				<?php endif; endforeach; ?>	
																			</div>
																		</div><!-- .entry-meta -->
																	<?php } ?>
																</figure><!-- .post-featured-image .post-img-wrap -->

															<?php } elseif ('post' === get_post_type()) { ?>

																<div class="entry-meta category-meta">
																	<div class="cat-links">
																		<?php
																			$terms = get_the_terms(get_the_ID(), 'category');
																			foreach($terms as $term) :
																				if ($term->slug != 'sexy') :
																		?>
																			<a href="<?php echo get_term_link($term->term_id); ?>"><?php echo $term->name; ?></a>
																		<?php endif; endforeach; ?>
																	</div>
																</div><!-- .entry-meta -->

															<?php } ?>

															<?php if (!has_post_format('quote')) { // for not format quote 
															?>

																<header class="entry-header">

																	<?php the_title('<h2 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>'); ?>

																	<?php if ('post' === get_post_type() && !has_post_format('link')) { ?>

																		<div class="entry-meta">
																			<?php newscard_posted_on(); ?>
																			<?php if (comments_open() && get_comments_number()) { ?>
																				<div class="comments">
																					<?php comments_popup_link(__('No Comments', 'newscard'), __('1 Comment', 'newscard'), __('% Comments', 'newscard'), '', __('Comments Off', 'newscard')); ?>
																				</div><!-- .comments -->
																			<?php } ?>
																		</div><!-- .entry-meta -->

																	<?php } ?>
																</header><!-- .entry-header -->

															<?php } ?>
															<!-- 
															<div class="entry-content">

																<?php if (!(has_post_format('link') || has_post_format('quote'))) { ?>

																	<p><?php echo wp_trim_words(get_the_excerpt(), 16); ?></p>

																<?php } else {

																	the_content();
																} ?>

															</div> -->
															<!-- .entry-content -->
														</div><!-- .post-<?php the_ID(); ?> -->
													</div><!-- .col-sm-6 .col-xxl-4 .post-col -->
												<?php }
												// Reset Post Data
												wp_reset_postdata(); ?>
											</div><!-- .row -->
										</div><!-- .featured-post -->
									</div><!-- <?php echo $col_mid_class ?> -->
								<?php } ?>
								<!-- <?php the_posts_pagination(
											array(
												'prev_text' => __('Previous', 'newscard'),
												'next_text' => __('Next', 'newscard'),
											)
										); ?> -->
							</div><!-- .row -->
						<?php } ?>

						<?php if ((is_front_page() || (is_home() && $newscard_settings['newscard_header_featured_posts_banner_display'] === 'front-blog')) && $newscard_settings['newscard_header_featured_posts_hide'] === 0) {

							$header_newscard_cat = absint($newscard_settings['newscard_header_featured_post_categories']);

							$header_post_type = array(
								'posts_per_page' => 4,
								'post__not_in' => get_option('sticky_posts'),
								'post_type' => array(
									'post'
								),
							);
							if ($newscard_settings['newscard_header_featured_latest_post'] == 'category') {
								$header_post_type['category__in'] = $header_newscard_cat;
							}

							$header_newscard_get_featured_post = new WP_Query($header_post_type); ?>

							<section class="featured-stories d-none">
								<?php newscard_sections_title($newscard_settings['newscard_header_featured_latest_post'], $newscard_settings['newscard_header_featured_posts_title'], $header_newscard_cat); ?>
								<div class="row gutter-parent-10">
									<?php while ($header_newscard_get_featured_post->have_posts()) {
										$header_newscard_get_featured_post->the_post(); ?>
										<div class="col-sm- col-lg-3 post-col">
											<div class="post-boxed">
												<?php if (has_post_thumbnail()) { ?>
													<div class="post-img-wrap">
														<div class="featured-post-img">
															<a href="<?php the_permalink(); ?>" class="post-img" style="background-image: url('<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'large')); ?>');"></a>
														</div>
														<div class="entry-meta category-meta">
															<div class="cat-links">
																<?php
																	$terms = get_the_terms(get_the_ID(), 'category');
																	foreach($terms as $term) :
																		if ($term->slug != 'sexy') :
																?>
																	<a href="<?php echo get_term_link($term->term_id); ?>"><?php echo $term->name; ?></a>
																<?php endif; endforeach; ?>	
															</div>
														</div><!-- .entry-meta -->
													</div><!-- .post-img-wrap -->
												<?php } ?>
												<div class="post-content">
													<?php if (!has_post_thumbnail()) { ?>
														<div class="entry-meta category-meta">
															<div class="cat-links">
																<?php
																	$terms = get_the_terms(get_the_ID(), 'category');
																	foreach($terms as $term) :
																		if ($term->slug != 'sexy') :
																?>
																	<a href="<?php echo get_term_link($term->term_id); ?>"><?php echo $term->name; ?></a>
																<?php endif; endforeach; ?>	
															</div>
														</div><!-- .entry-meta -->
													<?php } ?>
													<?php the_title('<h3 class="entry-title"><a href="' . esc_url(get_permalink()) . '">', '</a></h3>'); ?>
													<?php if ('post' === get_post_type()) { ?>
														<div class="entry-meta">
															<?php newscard_posted_on(); ?>
														</div>
													<?php } ?>
												</div><!-- .post-content -->
											</div><!-- .post-boxed -->
										</div><!-- .col-sm-6 .col-lg-3 .post-col-->
									<?php }
									// Reset Post Data
									wp_reset_postdata(); ?>
								</div><!-- .row -->
							</section><!-- .featured-stories -->
						<?php } ?>
					</div><!-- .container -->
				</section><!-- .featured-section -->
			<?php } ?>

			<?php if (!is_front_page() && !is_home() && !is_page_template('templates/front-page-template.php') && function_exists('newscard_breadcrumbs') && $newscard_settings['newscard_breadcrumbs_hide'] === 0) { ?>
				<div id="breadcrumb">
					<div class="container">
						<?php newscard_breadcrumbs(); ?>
					</div>
				</div><!-- .breadcrumb -->
			<?php } ?>
		</header><!-- #masthead -->
		<div id="content" class="site-content <?php echo (((is_front_page() || (is_home() && $newscard_settings['newscard_banner_display'] === 'front-blog')) && ($newscard_settings['newscard_banner_slider_posts_hide'] === 0 || $newscard_settings['newscard_banner_featured_posts_1_hide'] === 0 || $newscard_settings['newscard_banner_featured_posts_2_hide'] === 0)) || ((is_front_page() || (is_home() && $newscard_settings['newscard_header_featured_posts_banner_display'] === 'front-blog')) && $newscard_settings['newscard_header_featured_posts_hide'] === 0)) ? "pt-0" : ""; ?><?php echo is_single() ? ' template-single' : ''; ?>">
			<div class="container">
				<?php if (is_page_template('templates/front-page-template.php')) { ?>
					<div class="row gutter-14 justify-content-center site-content-row">
					<?php } else { ?>
						<div class="row justify-content-center site-content-row">
						<?php } ?>