<?php

/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package NewsCard
 */

?>
<?php global $newscard_settings; ?>
</div><!-- row -->
</div><!-- .container -->
</div><!-- #content .site-content-->
<style>
	.site-content {
		padding-top: 0;
	}
</style>
<footer id="colophon" class="site-footer" role="contentinfo">
	<?php if ((is_single() || is_front_page() || (is_home() && $newscard_settings['newscard_header_featured_posts_banner_display'] === 'front-blog')) && $newscard_settings['newscard_header_featured_posts_hide'] === 0) {

		$header_newscard_cat = absint($newscard_settings['newscard_header_featured_post_categories']);

		$header_post_type = array(
			'posts_per_page' => 4,
			'post__not_in' => get_option('sticky_posts'),
			'post_type' => array(
				'post'
			),
		);
		if ($newscard_settings['newscard_header_featured_latest_post'] == 'category') {
			$header_post_type['category__in'] = $header_newscard_cat;
		}

		$header_newscard_get_featured_post = new WP_Query($header_post_type); ?>
		<div class="container">
			<section class="featured-stories">
				<?php newscard_sections_title($newscard_settings['newscard_header_featured_latest_post'], $newscard_settings['newscard_header_featured_posts_title'], $header_newscard_cat); ?>
				<div class="row">
					<div class="col-12 col-sm-6 col-md-7 col-lg-8 col-xl-9">
						<div class="row gutter-parent-10">
							<?php while ($header_newscard_get_featured_post->have_posts()) {
								$header_newscard_get_featured_post->the_post(); ?>
								<div class="col-sm-6 col-lg-6 post-col">
									<div class="post-boxed">
										<?php if (has_post_thumbnail()) { ?>
											<div class="post-img-wrap">
												<div class="featured-post-img">
													<a href="<?php the_permalink(); ?>" class="post-img" style="background-image: url('<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'large')); ?>');"></a>
												</div>
												<div class="entry-meta category-meta">
													<div class="cat-links">
														<?php
															$terms = get_the_terms(get_the_ID(), 'category');
															foreach($terms as $term) :
																if ($term->slug != 'sexy') :
														?>
															<a href="<?php echo get_term_link($term->term_id); ?>"><?php echo $term->name; ?></a>
														<?php endif; endforeach; ?>		
													</div>
												</div><!-- .entry-meta -->
											</div><!-- .post-img-wrap -->
										<?php } ?>
										<div class="post-content">
											<?php if (!has_post_thumbnail()) { ?>
												<div class="entry-meta category-meta">
													<div class="cat-links">
														<?php
															$terms = get_the_terms(get_the_ID(), 'category');
															foreach($terms as $term) :
																if ($term->slug != 'sexy') :
														?>
															<a href="<?php echo get_term_link($term->term_id); ?>"><?php echo $term->name; ?></a>
														<?php endif; endforeach; ?>	
													</div>
												</div><!-- .entry-meta -->
											<?php } ?>
											<?php the_title('<h3 class="entry-title"><a href="' . esc_url(get_permalink()) . '">', '</a></h3>'); ?>
											<?php if ('post' === get_post_type()) { ?>
												<div class="entry-meta">
													<?php newscard_posted_on(); ?>
												</div>
											<?php } ?>
										</div><!-- .post-content -->
									</div><!-- .post-boxed -->
								</div><!-- .col-sm-6 .col-lg-3 .post-col-->
							<?php }
							// Reset Post Data
							wp_reset_postdata(); ?>
						</div><!-- .row -->
					</div>
					<div class="col-12 col-sm-6 col-md-5 col-lg-4 col-xl-3">
						<section id="block-25" class="widget widget_block widget_media_image">
							<figure class="wp-block-image size-large"><a href="https://www.instagram.com/entrevuefr/"><img decoding="async" loading="lazy" width="auto" height="864" src="https://www.entrevue.fr/wp-content/uploads/2023/06/ads-insta-2-1-min-512x1024.jpg" alt="https://www.instagram.com/entrevuefr/" style="max-height: 860px;" class="wp-image-22175" srcset="https://www.entrevue.fr/wp-content/uploads/2023/06/ads-insta-2-1-min-512x1024.jpg 512w, https://www.entrevue.fr/wp-content/uploads/2023/06/ads-insta-2-1-min-150x300.jpg 150w, https://www.entrevue.fr/wp-content/uploads/2023/06/ads-insta-2-1-min.jpg 800w" sizes="(max-width: 512px) 100vw, 512px"></a></figure>
						</section>
						<!-- <aside id="secondary" class="col-lg-4 widget-area" role="complementary">
							<div class="sticky-sidebar">
								<?php dynamic_sidebar('newscard_right_sidebar'); ?>
							</div>
						</aside> -->
					</div>
				</div>
			</section><!-- .featured-stories -->
		</div><!-- .container -->
	<?php } ?>
	<?php $page_id = 18215; ?>
	<?php if ($newscard_settings['newscard_footer_featured_posts_hide'] === 0 &&  $page_id !== get_the_ID()) {

		$footer_newscard_cat = absint($newscard_settings['newscard_footer_featured_post_categories']);

		$footer_post_type = array(
			'posts_per_page' => 2,
			'post__not_in' => get_option('sticky_posts'),
			'post_type' => array(
				'post'
			),
		);
		if ($newscard_settings['newscard_footer_featured_latest_post'] == 'category') {
			$footer_post_type['category__in'] = $footer_newscard_cat;
		}

		$footer_newscard_get_featured_post = new WP_Query($footer_post_type); ?>
		<div class="container">
			<section class="featured-stories featured-stories--new">
				<?php newscard_sections_title($newscard_settings['newscard_footer_featured_latest_post'], $newscard_settings['newscard_footer_featured_posts_title'], $footer_newscard_cat); ?>
				<div class="row gutter-parent-14">
					<?php while ($footer_newscard_get_featured_post->have_posts()) {
						$footer_newscard_get_featured_post->the_post(); ?>
						<div class="col-sm-6 col-lg-6">
							<div class="post-boxed">
								<?php if (has_post_thumbnail()) { ?>
									<div class="post-img-wrap">
										<div class="featured-post-img">
											<a href="<?php the_permalink(); ?>" class="post-img" style="background-image: url('<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'large')); ?>');"></a>
										</div>
										<div class="entry-meta category-meta">
											<div class="cat-links">
												<?php
													$terms = get_the_terms(get_the_ID(), 'category');
													foreach($terms as $term) :
														if ($term->slug != 'sexy') :
												?>
													<a href="<?php echo get_term_link($term->term_id); ?>"><?php echo $term->name; ?></a>
												<?php endif; endforeach; ?>		
											</div>
										</div><!-- .entry-meta -->
									</div><!-- .post-img-wrap -->
								<?php } ?>
								<div class="post-content">
									<?php if (!has_post_thumbnail()) { ?>
										<div class="entry-meta category-meta">
											<div class="cat-links">
												<?php
													$terms = get_the_terms(get_the_ID(), 'category');
													foreach($terms as $term) :
														if ($term->slug != 'sexy') :
												?>
													<a href="<?php echo get_term_link($term->term_id); ?>"><?php echo $term->name; ?></a>
												<?php endif; endforeach; ?>		
											</div>
										</div><!-- .entry-meta -->
									<?php } ?>
									<?php the_title('<h3 class="entry-title"><a href="' . esc_url(get_permalink()) . '">', '</a></h3>'); ?>
									<?php if ('post' === get_post_type()) { ?>
										<div class="entry-meta">
											<?php newscard_posted_on(); ?>
										</div>
									<?php } ?>
								</div><!-- .post-content -->
							</div><!-- .post-boxed -->
						</div><!-- .col-sm-6 .col-lg-3 -->
					<?php }
					// Reset Post Data
					wp_reset_postdata(); ?>
				</div><!-- .row -->
			</section><!-- .featured-stories -->
		</div><!-- .container -->
	<?php } ?>

	<?php if (is_active_sidebar('newscard_footer_sidebar') || is_active_sidebar('newscard_footer_column2') || is_active_sidebar('newscard_footer_column3') || is_active_sidebar('newscard_footer_column4')) { ?>
		<div class="widget-area">
			<div class="container">
				<div class="row">
					<div class="col-sm-6 col-lg-3">
						<?php
						// Calling the Footer Sidebar Column 1
						if (is_active_sidebar('newscard_footer_sidebar')) :
							dynamic_sidebar('newscard_footer_sidebar');
						endif;
						?>
					</div><!-- footer sidebar column 1 -->
					<div class="col-sm-6 col-lg-4">
						<?php
						// Calling the Footer Sidebar Column 2
						if (is_active_sidebar('newscard_footer_column2')) :
							dynamic_sidebar('newscard_footer_column2');
						endif;
						?>
					</div><!-- footer sidebar column 2 -->
					<div class="col-sm-12 col-lg-5">
						<div class="row">

							<div class="col-sm-6 col-lg-4">
								<?php
								// Calling the Footer Sidebar Column 3
								if (is_active_sidebar('newscard_footer_column3')) :
									dynamic_sidebar('newscard_footer_column3');
								endif;
								?>
							</div><!-- footer sidebar column 3 -->
							<div class="col-sm-6 col-lg-5">
								<?php
								// Calling the Footer Sidebar Column 4
								if (is_active_sidebar('newscard_footer_column4')) :
									dynamic_sidebar('newscard_footer_column4');
								endif;
								?>
							</div>
							<div class="col-sm-6 col-lg-12">
								<?php
								// Calling the Footer Sidebar Column 3
								if (is_active_sidebar('newscard_footer_column5')) :
									dynamic_sidebar('newscard_footer_column5');
								endif;
								?>
							</div><!-- footer sidebar column 3 -->
						</div>
					</div>
				</div><!-- .row -->
			</div><!-- .container -->
		</div><!-- .widget-area -->
	<?php } ?>
	<!-- <div class="site-info">
		<div class="container">
			<div class="row">
				<?php
				if ($newscard_settings['newscard_social_profiles'] != '') { ?>
					<div class="col-lg-auto order-lg-2 ml-auto">
						<div class="social-profiles">
							<?php echo esc_html(newscard_social_profiles()); ?>
						</div>
					</div>
				<?php } ?>
				<div class="copyright col-lg order-lg-1 text-lg-left">
					<div class="theme-link">
						<?php echo esc_html__('Copyright &copy; ', 'newscard') . newscard_the_year() . newscard_site_link(); ?></div><?php if (function_exists('the_privacy_policy_link')) {
																																			the_privacy_policy_link('<div class="privacy-link">', '</div>');
																																		}
																																		echo newscard_author_link() . newscard_wp_link(); ?>
				</div> 
			</div>
		</div>
	</div> -->
	<!-- .site-info -->
</footer><!-- #colophon -->
<div class="back-to-top"><a title="<?php esc_attr_e('Go to Top', 'newscard'); ?>" href="#masthead"><svg xmlns="http://www.w3.org/2000/svg" width="27" height="24" viewBox="0 0 27 24" fill="none">
			<path d="M13.5504 5L13.5504 21" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
			<path d="M19.8504 11L13.9805 4.1978C13.9268 4.13563 13.8607 4.08584 13.7866 4.05174C13.7126 4.01764 13.6322 4 13.551 4C13.4697 4 13.3894 4.01764 13.3153 4.05174C13.2413 4.08584 13.1752 4.13563 13.1214 4.1978L7.2504 11" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
		</svg></a></div>
</div><!-- #page -->

<?php wp_footer(); ?>

</body>

</html>