<?php
/**
 * Template Name: Listing Magazines
 *
 * Description: A page template that provides a key component of WordPress as a CMS
 * by meeting the need for a carefully crafted introductory page. The front page template
 * in Twenty Twelve consists of a page content area for adding text, images, video --
 * anything you'd like -- followed by front-page-only widgets in one or two columns.
 *
 * @package WordPress
 * @subpackage Twenty_Twelve
 * @since Twenty Twelve 1.0
 */
get_header(); ?>
	<div id="primary" class="site-content">
		<?php while ( have_posts() ) : the_post(); ?>
			<div id="content" role="main">
            	<header class="entry-header"><h2><?php the_title() ?></h2></header>
				<?php $args=array('post_type'=>'magazine','post_status'=>'publish','posts_per_page'=>-1,'order'=>'DESC','orderby'=>'meta_value_num','meta_key'=>'numero');query_posts( $args );?>
                <?php if(have_posts()):?>
                    <?php while (have_posts()) : the_post(); ?><?php get_template_part( 'content', get_post_format() )?><?php endwhile;?>
                <?php endif;?><?php wp_reset_query();?> 
				<?php the_content();?>
			</div><!-- #content -->
		<?php endwhile; // end of the loop. ?>
	</div><!-- #primary -->

<?php get_footer(); ?>